﻿using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI.WebControls;
using System.Web.Security.AntiXss;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;
using VIRP;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;
using VIRP_WEB.Controls.Custom.EFR.Controls;

namespace VIRP_WEB.Custom.EFR
{
    public partial class LabResultDetails : EfrBasePage
    {
        private const string ReferralKey = "LabResultDetails_Referrer";

        //private readonly LabResultsManager labResultsManager;
        //private readonly LabOrderManager labOrderManager;
        //private readonly WorkflowCaseManager workflowManager;

        //private WKF_CASE wCase;
        //private WKF_CASE_ACTIVITY activity;
        //private WKF_CASE_ACTIVITY order;
        //private WKF_CASE_ACTIVITY labKit;
        //private STD_WKFACTIVITYST activitySt;

        private VIRP.CRS.BO.WKF_CASE WkfCase
        {
            get
            {
                VIRP.CRS.BO.WKF_CASE wkfCase = null;

                if (ViewState["WkfCase"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(CurrentUser, CurrentRegistryId);
                    ViewState["WkfCase"] = wkfCase;
                }
                else
                {
                    wkfCase = ViewState["WkfCase"] as VIRP.CRS.BO.WKF_CASE;
                }

                return wkfCase;
            }
            set
            {
                ViewState["WkfCase"] = value;
            }
        }

        private VIRP.CRS.BO.WKF_CASE_ACTIVITY Activity
        {
            get
            {
                VIRP.CRS.BO.WKF_CASE_ACTIVITY activity = null;

                if (ViewState["Activity"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(CurrentUser, CurrentRegistryId);
                    ViewState["Activity"] = activity;
                }
                else
                {
                    activity = ViewState["Activity"] as VIRP.CRS.BO.WKF_CASE_ACTIVITY;
                }

                return activity;
            }
            set
            {
                ViewState["Activity"] = value;
            }
        }

        private WKF_CASE_ACTIVITY LabOrder
        {
            get
            {
                WKF_CASE_ACTIVITY labOrder = null;

                if (ViewState["LabOrder"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(CurrentUser, CurrentRegistryId);
                    ViewState["LabOrder"] = labOrder;
                }
                else
                {
                    labOrder = ViewState["LabOrder"] as WKF_CASE_ACTIVITY;
                }

                return labOrder;
            }
            set
            {
                ViewState["LabOrder"] = value;
            }
        }

        private WKF_CASE_ACTIVITY LabKit
        {
            get
            {
                WKF_CASE_ACTIVITY labKit = null;

                if (ViewState["LabKit"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(CurrentUser, CurrentRegistryId);
                    ViewState["LabKit"] = labKit;
                }
                else
                {
                    labKit = ViewState["LabKit"] as WKF_CASE_ACTIVITY;
                }

                return labKit;
            }
            set
            {
                ViewState["LabKit"] = value;
            }
        }

        private SPECIMEN_ANALYSIS Analysis
        {
            get
            {
                SPECIMEN_ANALYSIS analysis = null;

                if (ViewState["Analysis"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(CurrentUser, CurrentRegistryId);
                    ViewState["Analysis"] = analysis;
                }
                else
                {
                    analysis = ViewState["Analysis"] as SPECIMEN_ANALYSIS;
                }

                return analysis;
            }
            set
            {
                ViewState["Analysis"] = value;
            }
        }

        private VIRP.CRS.BO.STD_WKFACTIVITYSTS activitySt;

        private static IReadOnlyList<string> navigationSources = new List<string>
        {
            "/Custom/EFR/LabOrders/LabOrder.aspx",
            "/Custom/EFR/LabResults/LabResults.aspx",
            "/Custom/EFR/Patients/PatientWorkflows.aspx"
        };

        public LabResultDetails()
        {
            //labResultsManager = new LabResultsManager();
            //labOrderManager = new LabOrderManager();
            ////workflowManager = new WorkflowCaseManager();

            ////Manager Save Notification Event Handler
            //labResultsManager.BOSaveSuccess += Manager_BOSaveSuccess;
            //labOrderManager.BOSaveSuccess += Manager_BOSaveSuccess;

            NavigationSources = navigationSources;
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                int WKFCaseActivityId = Convert.ToInt32(AntiXssEncoder.HtmlEncode(Request.QueryString["ActivityId"], false));

                BindData(WKFCaseActivityId);
                //TODO - Move breadcrumb logic to menubuilder and master page. Added here to avoid error out in Referral pages.

                SetOriginalReferringPage(ReferralKey);
                SetReferringPage();
            }

            if (!UserSession.IsSystemAdministrator && !UserSession.IsRegistryAdministrator)
            {
                btnAccept.Enabled = false;
                btnReject.Enabled = false;
            }
        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            DisableRequiredValidatorForResultsWhenUpdating();
        }

        private void DisableRequiredValidatorForResultsWhenUpdating()
        {
            if (ViewState["EditMode"] != null)
            {
                if (AnalyteList.EditItemIndex >= 0)
                {
                    DataListItem listItem = AnalyteList.Items[AnalyteList.EditItemIndex];
                    if (listItem != null)
                    {
                        RequiredFieldValidator validator = (RequiredFieldValidator)listItem.FindControl("AnalysisResultBoxRequiredValidator");
                        if (validator != null)
                        {
                            if (Convert.ToBoolean(ViewState["EditMode"]))
                            {
                                validator.Enabled = false;
                            }
                            else
                            {
                                validator.Enabled = true;
                            }
                        }
                    }
                }
            }
        }

        #region DataList events 
        protected void AnalyteList_EditCommand(object sender, DataListCommandEventArgs e)
        {
            //Deserialize();
            AnalyteList.EditItemIndex = e.Item.ItemIndex;
            AnalyteList.ShowFooter = false;
            ViewState["EditMode"] = true;

            BindDataList();
        }

        protected void AnalyteList_UpdateCommand(object sender, DataListCommandEventArgs e)
        {
            //Deserialize();
            AnalyteList.EditItemIndex = -1;
            AnalyteList.ShowFooter = true;

            int index = e.Item.ItemIndex;
            AnalyteList.SelectedIndex = index;
            ViewState["EditMode"] = false;
            int id = int.Parse(AnalyteList.SelectedValue.ToString());
            UpdateCreateDataListAnalyte(e.Item, id, false);
            BindDataList();
        }

        protected void AnalyteList_CancelCommand(object sender, DataListCommandEventArgs e)
        {
            //Deserialize();
            AnalyteList.EditItemIndex = -1;
            AnalyteList.ShowFooter = true;
            ViewState["EditMode"] = false;
            BindDataList();
        }

        protected void AnalyteList_DeleteCommand(object sender, DataListCommandEventArgs e)
        {
            //Deserialize();
            int index = e.Item.ItemIndex;
            AnalyteList.SelectedIndex = index;

            int id = int.Parse(AnalyteList.SelectedValue.ToString());

            DeleteAnalyte(id);

            AnalyteList.ShowFooter = true;
            BindDataList();
        }
        //have to load analyte in this event since edit template already loaded at this point
        protected void AnalyteList_DataBound(object sender, DataListItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.EditItem && bool.Parse(ViewState["EditMode"].ToString()) == true)
            {
                int index = e.Item.ItemIndex;
                AnalyteList.SelectedIndex = index;

                int id = int.Parse(AnalyteList.SelectedValue.ToString());
                LoadDataListAnalyte(e.Item, id);
            }

            //Deserialize();

            if (Activity.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Accepted)
            {
                if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem
                    || e.Item.ItemType == ListItemType.SelectedItem)
                {
                    Button edit = e.Item.FindControl("ButtonEdit") as Button;

                    if (edit != null)
                        edit.Enabled = false;

                    Button delete = e.Item.FindControl("ButtonDelete") as Button;

                    if (delete != null)
                        delete.Enabled = false;
                }
                else if (e.Item.ItemType == ListItemType.Footer)
                    DisableAllControls(e.Item);
            }
        }

        protected void AnalyteList_ItemCommand(object sender, DataListCommandEventArgs e)
        {
            int id = 0;
            if (e.CommandName.Equals("Insert"))
            {
                //Deserialize();
                UpdateCreateDataListAnalyte(e.Item, id, true);
                BindDataList();
                //set the flag for dropdown focus
                dataListViewAddModeFlag.Value = "1";
                ClearAllControls(e.Item);
            }
        }

        protected void AnalyteList_PreRender(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);

            try
            {
                DataList AnalyteDL = (DataList)sender;
                if (AnalyteDL.Items.Count == 0)
                    AnalyteDL.ShowFooter = true;
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);
                throw ex;
            }
        }

        #endregion

        private void ClearAllControls(DataListItem item)
        {
            List<TextBox> textBoxes = item.GetAllControls().OfType<TextBox>().ToList();

            textBoxes.ForEach(elem => elem.Text = string.Empty);

            List<DropDownList> lists = item.GetAllControls().OfType<DropDownList>().ToList();

            lists.ForEach(elem => elem.SelectedIndex = -1);

            List<CheckBox> checks = item.GetAllControls().OfType<CheckBox>().ToList();

            checks.ForEach(elem => elem.Checked = false);
        }

        private void DisableAllControls(DataListItem item)
        {
            List<TextBox> textBoxes = item.GetAllControls().OfType<TextBox>().ToList();

            textBoxes.ForEach(elem => elem.Enabled = false);

            List<DropDownList> lists = item.GetAllControls().OfType<DropDownList>().ToList();

            lists.ForEach(elem => elem.Enabled = false);

            List<CheckBox> checks = item.GetAllControls().OfType<CheckBox>().ToList();

            checks.ForEach(elem => elem.Enabled = false);

            List<Button> buttons = item.GetAllControls().OfType<Button>().ToList();

            buttons.ForEach(elem => elem.Enabled = false);
        }

        private void GetRefreshLabResults(int activityId)
        {
            WkfCase = VIRP.CRS.BLL.WKF_CASEManager.GetItemByActivity(CurrentUser, CurrentRegistryId, activityId);
            //WkfCase = labResultsManager.GetLabResultDetails(activityId);

            //TODO - Check the default value
            Activity = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.GetItem(CurrentUser, CurrentRegistryId, activityId);
            //Activity = WkfCase.WKF_CASE_ACTIVITies[0];

            //ViewState["WCase"] = WkfCase.Serialize();

            LabOrder = GetLabOrderByCaseId(WkfCase.WKF_CASE_ID);
            //ViewState["Order"] = LabOrder.Serialize();

            LabKit = SelectByActivityType(WkfCase.WKF_CASE_ID, "LabKit");
            //ViewState["LabKit"] = LabKit.Serialize();

            if (LabOrder != null)
            {
                LabOrderLink.Visible = true;
                LabOrderLink.NavigateUrl = "~/Custom/EFR/LabOrders/LabOrder.aspx?activityId=" + LabOrder.WKF_CASE_ACTIVITY_ID;
            }
        }

        private void BindData(int wkfCaseActivityId)
        {
            GetRefreshLabResults(wkfCaseActivityId);

            PatientLabInfo Info = new PatientLabInfo();

            if (Activity != null)
            {
                if (Activity.WKF_CASE.REFERRAL.PATIENT != null)
                {
                    Info.Name = VIRP_WEB.BaseCode.Helpers.FullName(Activity.WKF_CASE.REFERRAL.PATIENT); //.FullName;
                    Info.ID = Activity.WKF_CASE.REFERRAL.PATIENT.PATIENT_ID.ToString();
                    //Info.ICN = activity.WKF_CASE.REFERRAL.PATIENT.PATIENT_ICN;
                    Info.ICN = Activity.WKF_CASE.REFERRAL.PATIENT.PatientICN;
                    Info.BirthDate = ConvertDateToString(Activity.WKF_CASE.REFERRAL.PATIENT.BIRTH_DATE);

                    PATIENT_REG patientReg = ServiceInterfaceManager.PATIENT_REG_GET(CurrentUser, CurrentRegistryId, Activity.WKF_CASE.REFERRAL.PATIENT.PATIENT_ID);

                    //if (Activity.WKF_CASE.REFERRAL.PATIENT.SPATIENT != null)
                    if (patientReg != null)
                    {
                        //Info.Snum = activity.WKF_CASE.REFERRAL.PATIENT.Snum;
                        //Info.Snum = Activity.WKF_CASE.REFERRAL.PATIENT.SPATIENT.PatientSnum;
                        Info.Snum = patientReg.Snum;
                        //Info.Gender = activity.WKF_CASE.REFERRAL.PATIENT.STD_GENDER.NAME;
                        //Info.Gender = VIRP_WEB.BaseCode.Helpers.GetGender(CurrentUser, CurrentRegistryId, Activity.WKF_CASE.REFERRAL.PATIENT.SPATIENT.STD_GENDER_ID.GetValueOrDefault());
                        Info.Gender = VIRP_WEB.BaseCode.Helpers.GetGender(CurrentUser, CurrentRegistryId, patientReg.STD_GENDER_ID.GetValueOrDefault());
                        //Info.PostalCode = activity.WKF_CASE.REFERRAL.PATIENT.POSTAL_CODE;
                        //Info.PostalCode = Activity.WKF_CASE.REFERRAL.PATIENT.SPATIENT.PostalCode;
                        Info.PostalCode = patientReg.POSTAL_CODE;
                    }
                }

                Info.LabContact = Activity.CONTACT_NAME;
                Info.WorkFlowCaseId = Activity.WKF_CASE_ID.ToString();
                //activitySt = activity.STD_WKFACTIVITYST;
                activitySt = Activity.STD_WKFACTIVITYSTS;
                ViewState["OrderType"] = activitySt.ID;
                switch (activitySt.ID)
                {
                    case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.New:
                        btnSave.Enabled = btnAccept.Enabled = btnReject.Enabled = true;
                        btnSave.Text = "Save";
                        break;
                    case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.InProcess:
                        btnSave.Enabled = btnAccept.Enabled = btnReject.Enabled = true;
                        btnSave.Text = "Save";
                        break;
                    case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Accepted:
                        btnSave.Enabled = btnReject.Enabled = btnAccept.Enabled = false;
                        btnSave.Text = "Save";
                        break;
                    case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided:
                        btnSave.Enabled = btnAccept.Enabled = true;
                        btnReject.Enabled = false;
                        btnSave.Text = "Un-Void";
                        break;
                    default:
                        break;
                }

                // WAS: if (currentUser.GetRoles().Contains((int)RoleCode.EFR_TEFSC_COORDINATOR))
                if (UserSession.IsSystemAdministrator || UserSession.IsRegistryAdministrator)
                    UnacceptLabResults(activitySt.ID, Activity.WKF_CASE_ID, btnAccept);

                List<SPECIMEN_ANALYSIS> analysisList = SPECIMEN_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, Activity.WKF_CASE_ACTIVITY_ID);
                if (analysisList != null && analysisList.Count > 0)
                {
                    SPECIMEN_ANALYSIS analysis = analysisList.First();
                    Info.Accession = analysis.LAB_UID_NUMBER;

                    Info.SpecColnDate = ConvertDateToString(analysis.SPECIMEN_COLLECTION_DATE);
                    txtElapsedTime.Text = analysis.TIME_ELAPSED_NUMBER;
                    txtTotalVolume.Text = analysis.TOTAL_VOLUME_NUMBER;
                    txtVolOfAnalyteTests.Text = analysis.ANALYTE_VOLUME_NUMBER;
                    //Populate Analyte details
                    Info.ReportDate = ConvertDateToString(analysis.LAB_REPORT_DATE);
                    Info.LabName = analysis.LAB_NAME;
                }

                //if (Activity.SPECIMEN_ANALYSIs.Count() > 0)
                //{
                //    Info.Accession = Activity.SPECIMEN_ANALYSIs[0].LAB_UID_NUMBER;

                //    Info.SpecColnDate = ConvertDateToString(Activity.SPECIMEN_ANALYSIs[0].SPECIMEN_COLLECTION_DATE);
                //    txtElapsedTime.Text = Activity.SPECIMEN_ANALYSIs[0].TIME_ELAPSED_NUMBER;
                //    txtTotalVolume.Text = Activity.SPECIMEN_ANALYSIs[0].TOTAL_VOLUME_NUMBER;
                //    txtVolOfAnalyteTests.Text = Activity.SPECIMEN_ANALYSIs[0].ANALYTE_VOLUME_NUMBER;
                //    //Populate Analyte details
                //    Info.ReportDate = ConvertDateToString(Activity.SPECIMEN_ANALYSIs.First().LAB_REPORT_DATE);
                //    Info.LabName = Activity.SPECIMEN_ANALYSIs[0].LAB_NAME;
                //}

                if (Info.LabName == null)
                    Info.LabName = "Baltimore VA lab";

                //if (LabOrder == null)
                //    LabOrder = ViewState["Order"] as WKF_CASE_ACTIVITY;

                //if (LabKit == null)
                //    LabKit = ViewState["LabKit"] as WKF_CASE_ACTIVITY;

                if (LabKit != null)
                {
                    List<SHIPPING_DETAIL> shipDetailList = SHIPPING_DETAILManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, LabKit.WKF_CASE_ACTIVITY_ID);
                    if (shipDetailList != null && shipDetailList.Count > 0)
                    {
                        SHIPPING_DETAIL shipDetail = shipDetailList.First();
                        Info.KitReceivedDate = shipDetail.RECEIVED_DATE.HasValue ? shipDetail.RECEIVED_DATE.Value.ToString("d") : string.Empty;
                    }
                    //Info.KitReceivedDate = LabKit.SHIPPING_DETAILs.First().RECEIVED_DATE.HasValue ? LabKit.SHIPPING_DETAILs.First().RECEIVED_DATE.Value.ToString("d") : string.Empty;
                }

                BindDataList();

                BioLabResultUserControl1.SetfieldValues(Info, false);
                
                ReplacePageTitle("My Tasks > Lab Results > " + activitySt.NAME + " > Workflow ID " + WkfCase.WKF_CASE_ID.ToString());
            }
        }

        /// <summary>
        /// Database update when "Unaccept" button is clicked.
        /// </summary>
        private void UnacceptButtonClick()
        {
            //Deserialize();

            OpenCloseReferralAndWorkflowCase(WkfCase, () => "Save");

            UnacceptLabResults(Activity, WkfCase);

            Response.Redirect("LabResults.aspx?OrderType=" + Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.InProcess));
        }

        protected void BtnAccept_Click(object sender, EventArgs e)
        {
            if (btnAccept.Text == "Unaccept")
            {
                UnacceptButtonClick();
            }
            else
            {
                //Deserialize();
                //WkfCase.SetAsChangeTrackingRoot(true);
                //Change the Activity status to Accepted
                Activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Accepted);

                //Insert a new Activity for Interpretation if none exist
                if (GetInterpretationLetterWorkcaseActivity(WkfCase.WKF_CASE_ID, (int)VIRP.EFR.BO.WorkFlowCaseActivityType.InterpretationDiagnosis) == null)
                {
                    WKF_CASE_ACTIVITY InterpreTationActivity = CreateNewInterpretationActivity(WkfCase.WKF_CASE_ID);
                    InterpreTationActivity.WKF_CASE_ACTIVITY_ID = ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(CurrentUser, CurrentRegistryId, InterpreTationActivity);
                    //WkfCase.WKF_CASE_ACTIVITies.Add(InterpreTationActivity);
                    //InterpreTationActivity.SetAsInsertOnSubmit();
                }

                OpenCloseReferralAndWorkflowCase(WkfCase, () => "Receive");
                SaveCompleteLabResults();

                List<SPECIMEN_ANALYSIS> analysisList = SPECIMEN_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, Activity.WKF_CASE_ACTIVITY_ID);
                if (analysisList != null && analysisList.Count > 0)
                {
                    SPECIMEN_ANALYSIS analysis = analysisList.First();
                    analysis.RESULT_ACKNOWLEDGE_FLAG = true;
                    analysis.RESULT_ACKNOWLEDGE_DATE = Helpers.ConvertStringToNullable<DateTime>(DateTime.Today.ToShortDateString());
                    analysis.SPECIMEN_ANALYSIS_ID = SPECIMEN_ANALYSISManager.Save(CurrentUser, CurrentRegistryId, analysis);
                }

                //if (Activity.SPECIMEN_ANALYSIs.Count() > 0)
                //{
                //    SPECIMEN_ANALYSI specmn = Activity.SPECIMEN_ANALYSIs[0];
                //    specmn.RESULT_ACKNOWLEDGE_FLAG = true;
                //    specmn.RESULT_ACKNOWLEDGE_DATE = CRS_EFR.Helpers.ConvertStringToNullable<DateTime>(DateTime.Today.ToShortDateString());
                //}

                //WkfCase is saved in OpenClose function above
                //WkfCase.WKF_CASE_ID = ServiceInterfaceManager.WKF_CASE_SAVE(CurrentUser, CurrentRegistryId, WkfCase);
                //labResultsManager.UpdateResultActivity(WkfCase);

                //LabOrder.SetAsChangeTrackingRoot();
                LabOrder.STD_WKFACTIVITYSTS_ID = (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Closed;

                List<LAB_ORDER> orders = LAB_ORDERManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, LabOrder.WKF_CASE_ACTIVITY_ID);
                if (orders != null && orders.Count > 0)
                {
                    LAB_ORDER order = orders.First();
                    order.LAB_RETURN_DATE = Helpers.ConvertStringToNullable<DateTime>(((TextBox)BioLabResultUserControl1.FindControl("TextBoxReportDate")).Text);
                    order.LAB_ORDER_ID = LAB_ORDERManager.Save(CurrentUser, CurrentRegistryId, order);
                }
                LabOrder.WKF_CASE_ACTIVITY_ID = ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(CurrentUser, CurrentRegistryId, LabOrder);

                //LabOrder.LAB_ORDERs.First().LAB_RETURN_DATE = CRS_EFR.Helpers.ConvertStringToNullable<DateTime>(((TextBox)BioLabResultUserControl1.FindControl("TextBoxReportDate")).Text);
                //labOrderManager.Update(LabOrder);

                Activity.WKF_CASE_ACTIVITY_ID = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, Activity);

                BindData(Activity.WKF_CASE_ACTIVITY_ID);

                ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
            }
        }

        protected void BtnReject_Click(object sender, EventArgs e)
        {
            //Deserialize();
            //Activity.SetAsChangeTrackingRoot(true);
            //Change the Activity status to Voided
            Activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided);

            OpenCloseReferralAndWorkflowCase(WkfCase, () => "Void");
            SaveCompleteLabResults();

            //WkfCase is saved in OpenClose function above
            //WkfCase.WKF_CASE_ID = ServiceInterfaceManager.WKF_CASE_SAVE(CurrentUser, CurrentRegistryId, WkfCase);
            //labResultsManager.UpdateResultActivity(WkfCase);

            Activity.WKF_CASE_ACTIVITY_ID = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, Activity);

            BindData(Activity.WKF_CASE_ACTIVITY_ID);

            ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
        }

        protected void BtnSave_Click(object sender, EventArgs e)
        {
            //Deserialize();
            //Activity.SetAsChangeTrackingRoot(true);
            //Change the Activity status to In Process
            if (Activity.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.New
                || Activity.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.InProcess
                || Activity.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided)
            {
                Activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.InProcess);
            }

            OpenCloseReferralAndWorkflowCase(WkfCase, () => "Save");
            SaveCompleteLabResults();

            //WkfCase is saved in OpenClose function above
            //WkfCase.WKF_CASE_ID = ServiceInterfaceManager.WKF_CASE_SAVE(CurrentUser, CurrentRegistryId, WkfCase);
            //labResultsManager.UpdateResultActivity(WkfCase);

            Activity.WKF_CASE_ACTIVITY_ID = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, Activity);

            BindData(Activity.WKF_CASE_ACTIVITY_ID);

            ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
        }

        protected void BtnCancel_Click(object sender, EventArgs e)
        {
            Uri from = ViewState["referrer"] as Uri;
            if (from != null && UriUtility.IsValidPathSource(NavigationSources, from))
            {
                if (from.PathAndQuery != null && from.PathAndQuery.Contains("LabOrder.aspx"))
                    RedirectToOriginalReferringPage(ReferralKey);
                else
                    RedirectToReferringPage();
            }
        }

        //private void Deserialize()
        //{
        //    WkfCase = SerializerUtil.Deserialize<WKF_CASE>((string)ViewState["WCase"]);
        //    LabOrder = SerializerUtil.Deserialize<WKF_CASE_ACTIVITY>((string)ViewState["Order"]);

        //    Activity = WkfCase.WKF_CASE_ACTIVITies[0];
        //}

        private void SaveCompleteLabResults()
        {
            PatientLabInfo info = new PatientLabInfo();
            BioLabResultUserControl1.GetfieldValues(info);

            Activity.CONTACT_NAME = info.LabContact;

            SPECIMEN_ANALYSIS analysis = Analysis;
            if (analysis == null)
            {
                List<SPECIMEN_ANALYSIS> analysisList = SPECIMEN_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, Activity.WKF_CASE_ACTIVITY_ID);
                if (analysisList == null || analysisList.Count < 1)
                {
                    PrepareSpecimenData();
                    analysis = Analysis;
                }
                else
                {
                    analysis = analysisList.First();
                }
            }

            analysis.LAB_UID_NUMBER = info.Accession;
            analysis.SPECIMEN_COLLECTION_DATE = Helpers.ConvertStringToNullable<DateTime>(info.SpecColnDate);
            analysis.TIME_ELAPSED_NUMBER = txtElapsedTime.Text.Trim();
            analysis.TOTAL_VOLUME_NUMBER = txtTotalVolume.Text.Trim();
            analysis.ANALYTE_VOLUME_NUMBER = txtVolOfAnalyteTests.Text.Trim();
            analysis.LAB_REPORT_DATE = Helpers.ToNullable<DateTime>(info.ReportDate);
            analysis.SPECIMEN_ANALYSIS_ID = SPECIMEN_ANALYSISManager.Save(CurrentUser, CurrentRegistryId, analysis);

            Analysis = analysis;

            //if (Activity.SPECIMEN_ANALYSIs.Count() == 0)
            //{
            //    PrepareSpecimenData();
            //}
            //if (Activity.SPECIMEN_ANALYSIs.Count() > 0)
            //{
            //    Activity.SPECIMEN_ANALYSIs.First().LAB_UID_NUMBER = info.Accession;
            //    Activity.SPECIMEN_ANALYSIs.First().SPECIMEN_COLLECTION_DATE = Helpers.ConvertStringToNullable<DateTime>(info.SpecColnDate);
            //    Activity.SPECIMEN_ANALYSIs.First().TIME_ELAPSED_NUMBER = txtElapsedTime.Text.Trim();
            //    Activity.SPECIMEN_ANALYSIs.First().TOTAL_VOLUME_NUMBER = txtTotalVolume.Text.Trim();
            //    Activity.SPECIMEN_ANALYSIs.First().ANALYTE_VOLUME_NUMBER = txtVolOfAnalyteTests.Text.Trim();

            //    Activity.SPECIMEN_ANALYSIs.First().LAB_REPORT_DATE = Helpers.ToNullable<DateTime>(info.ReportDate);
            //}
        }

        private void BindDataList()
        {
            //if (Activity == null)
            //    Deserialize();

            List<SPECIMEN_ANALYSIS> analysisList = SPECIMEN_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, Activity.WKF_CASE_ACTIVITY_ID);
            if (analysisList != null && analysisList.Count > 0)
            {
                SPECIMEN_ANALYSIS analysis = analysisList.First();
                List<ANALYSIS_DETAIL> detailList = ANALYSIS_DETAILManager.GetItemsBySpecimen(CurrentUser, CurrentRegistryId, analysis.SPECIMEN_ANALYSIS_ID);
                if (detailList != null)
                {
                    detailList = detailList.OrderBy(n => SortByLabResults(n.STD_TEST_NAME_ID, n.ANALYTE_NAME)).ToList();
                    AnalyteList.DataSource = detailList;
                }
                else
                    AnalyteList.DataSource = new List<ANALYSIS_DETAIL>();
            }
            else
                AnalyteList.DataSource = new List<ANALYSIS_DETAIL>();

            //if (Activity.SPECIMEN_ANALYSIs.Count() > 0)
            //    AnalyteList.DataSource = Activity.SPECIMEN_ANALYSIs[0].ANALYSIS_DETAILs.OrderBy("SortByLabResults");
            //else
            //    AnalyteList.DataSource = new List<SPECIMEN_ANALYSI>();

            AnalyteList.DataBind();
        }

        private string SortByLabResults(int? STD_TEST_NAME_ID, string ANALYTE_NAME)
        {
            string result = string.Empty;

            switch ((int)STD_TEST_NAME_ID)
            {
                case 8: //TestNameCreatinine:
                    result = "2" + ANALYTE_NAME;
                    break;
                case 6: //TestNameMassSpec:
                    result = "3" + ANALYTE_NAME;
                    break;
                case 4: //TestNameStandardized:
                    result = "4" + ANALYTE_NAME;
                    break;
                case 7: //TestNameConcentration:
                    result = "1" + ANALYTE_NAME;
                    break;
                case 9: //TestNameRatioU235U238:
                    result = "3" + "Uranium" + "2";
                    break;
                default:
                    result = "9" + ANALYTE_NAME;
                    break;
            }

            return result;
        }

        private void DeleteAnalyte(int analyteId)
        {
            ANALYSIS_DETAILManager.Delete(CurrentUser, CurrentRegistryId, analyteId);

            //ANALYSIS_DETAIL detail = Activity.SPECIMEN_ANALYSIs.First().ANALYSIS_DETAILs.Where(t => t.ANALYSIS_DETAIL_ID == analyteId).SingleOrDefault();
            //WkfCase.SetAsChangeTrackingRoot(true);
            //detail.SetAsDeleteOnSubmit();

            WkfCase.WKF_CASE_ID = VIRP.CRS.BLL.WKF_CASEManager.Save(CurrentUser, CurrentRegistryId, WkfCase);
            //labResultsManager.UpdateResultActivity(WkfCase);

            GetRefreshLabResults(Activity.WKF_CASE_ACTIVITY_ID);
        }

        private void LoadDataListAnalyte(DataListItem item, int detailId)
        {
            ANALYSIS_DETAIL detail = ANALYSIS_DETAILManager.GetItem(CurrentUser, CurrentRegistryId, detailId);
            //ANALYSIS_DETAIL detail = Activity.SPECIMEN_ANALYSIs.First().ANALYSIS_DETAILs.Where(t => t.ANALYSIS_DETAIL_ID == detailId).SingleOrDefault();

            if (detail != null)
            {
                if (detail.STD_TEST_NAME_ID.HasValue)
                {
                    DropDownList testNamesList = item.FindControl("TestNameList") as DropDownList;
                    if (testNamesList != null)
                        testNamesList.SelectedIndex = testNamesList.Items.IndexOf(testNamesList.Items.FindByValue(detail.STD_TEST_NAME_ID.Value.ToString()));
                }

                if (detail.STD_ANALYTETYPE_ID.HasValue)
                {
                    DropDownList analyteNamesList = item.FindControl("AnalyteNameList") as DropDownList;
                    if (analyteNamesList != null)
                    {
                        analyteNamesList.SelectedIndex = analyteNamesList.Items.IndexOf(analyteNamesList.Items.FindByValue(detail.STD_ANALYTETYPE_ID.Value.ToString()));
                    }

                    if (detail.STD_ANALYTETYPE_ID.Value == 15)
                    {
                        TextBox otherAnalyteBox = item.FindControl("OtherAnalyteBox") as TextBox;
                        if (otherAnalyteBox != null)
                            otherAnalyteBox.Text = detail.ANALYTE_NAME;
                    }
                }

                if (detail.STD_ANALYSISMETHOD_ID.HasValue)
                {
                    DropDownList analysisMethodsList = item.FindControl("AnalysisMethodList") as DropDownList;
                    if (analysisMethodsList != null)
                    {
                        analysisMethodsList.SelectedIndex = analysisMethodsList.Items.IndexOf(analysisMethodsList.Items.FindByValue(detail.STD_ANALYSISMETHOD_ID.Value.ToString()));
                    }

                    if (detail.STD_ANALYSISMETHOD_ID == 7)
                    {
                        TextBox otherAnalysisBox = item.FindControl("OtherAnalysisMethodBox") as TextBox;
                        if (otherAnalysisBox != null)
                            otherAnalysisBox.Text = detail.ANALYSIS_METHOD_NAME;
                    }
                }

                //analysis result 
                TextBox analysisResultBox = item.FindControl("AnalysisResultBox") as TextBox;
                if (analysisResultBox != null)
                    analysisResultBox.Text = detail.RESULT_TEXT;

                //result units - this unit label is no longer in use, used dropdown instead 

                DropDownList resultUnitList = item.FindControl("UnitList") as DropDownList;
                if (detail.RESULT_UNIT_ID.HasValue)
                {
                    if (resultUnitList != null)
                        resultUnitList.SelectedValue = detail.RESULT_UNIT_ID.Value.ToString();
                }

                //new dropdown for lab range units
                if (detail.LAB_REFERENCE_RANGE_UNIT_ID.HasValue)
                {
                    DropDownList rangeUnitList = item.FindControl("ReferenceRangeUnitList") as DropDownList;
                    //rangeUnitList.SelectedIndex = rangeUnitList.Items.IndexOf(rangeUnitList.Items.FindByValue(detail.STD_UNIT.NAME));
                    if (rangeUnitList != null)
                        rangeUnitList.SelectedValue = detail.LAB_REFERENCE_RANGE_UNIT_ID.Value.ToString();
                }

                CheckBox commentCheck = item.FindControl("ResultCommentCheck") as CheckBox;
                TextBox rangeBox = item.FindControl("ReferenceRangeBox") as TextBox;

                if (!string.IsNullOrEmpty(detail.LAB_REFERENCE_RANGE))
                {
                    if (rangeBox != null)
                        rangeBox.Text = detail.LAB_REFERENCE_RANGE;
                }
                else
                {
                    if (commentCheck != null)
                        commentCheck.Checked = true;
                }

                if (!string.IsNullOrEmpty(detail.OTHER_COMMENT_TEXT))
                {
                    if (commentCheck != null)
                        commentCheck.Checked = true;
                }

                CheckBox aboveCheck = item.FindControl("AboveReferenceCheck") as CheckBox;

                if (aboveCheck != null)
                    aboveCheck.Checked = detail.LAB_ABOVE_REFERENCE_RANGE.Equals(1);

                TextBox evalNoteBox = item.FindControl("EvaluationNoteBox") as TextBox;
                if (evalNoteBox != null)
                    evalNoteBox.Text = detail.EVAL_COMMENT_TEXT;

                TextBox commentBox = item.FindControl("CommentBox") as TextBox;
                if (commentBox != null)
                    commentBox.Text = detail.OTHER_COMMENT_TEXT;
            }
        }

        private void PrepareSpecimenData()
        {
            List<SPECIMEN_ANALYSIS> analysisList = SPECIMEN_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, Activity.WKF_CASE_ACTIVITY_ID);
            if (analysisList != null && analysisList.Count > 0)
            {
                Analysis = analysisList.First();
            }
            else
            {
                Analysis = AddNewSpecimen();
                Analysis.SPECIMEN_ANALYSIS_ID = SPECIMEN_ANALYSISManager.Save(CurrentUser, CurrentRegistryId, Analysis);
            }

            //SPECIMEN_ANALYSI analysis = null;
            ////Add a new fragment if it does not exist
            //if (Activity.FRAGMENT_ANALYSIs == null || Activity.FRAGMENT_ANALYSIs.Count() == 0)
            //{
            //    analysis = AddNewSpecimen();
            //    analysis.SetAsInsertOnSubmit();
            //}
            //else
            //    analysis = Activity.SPECIMEN_ANALYSIs[0];
        }

        private SPECIMEN_ANALYSIS AddNewSpecimen()
        {
            SPECIMEN_ANALYSIS specimen = new SPECIMEN_ANALYSIS();
            specimen.CREATED = specimen.UPDATED = DateTime.Now;
            specimen.CREATEDBY = specimen.UPDATEDBY = CurrentUser;
            specimen.WKF_CASE_ACTIVITY_ID = Activity.WKF_CASE_ACTIVITY_ID;
            specimen.LAB_ORDER_ID = GetLabOrderId(Activity.WKF_CASE_ACTIVITY_ID);
            specimen.RESULT_ACKNOWLEDGE_FLAG = false;

            //SPECIMEN_ANALYSI specimen = new SPECIMEN_ANALYSI();
            //specimen.WKF_CASE_ACTIVITY_ID = Activity.WKF_CASE_ACTIVITY_ID;
            //specimen.LAB_ORDER_ID = labResultsManager.GetLabOrderId(Activity.WKF_CASE_ACTIVITY_ID);
            //specimen.RESULT_ACKNOWLEDGE_FLAG = false;
            //Activity.SPECIMEN_ANALYSIs.Add(specimen);

            return specimen;
        }

        private void OpenCloseReferralAndWorkflowCase(VIRP.CRS.BO.WKF_CASE parentCase, Func<string> operation)
        {
            //Copied from LabKitDetails

            //VIRP_WEB.SoaServices.REFERRAL parentReferral = ServiceInterfaceManager.REFERRAL_GET(CurrentUser, CurrentRegistryId, parentCase.REFERRAL_ID.GetValueOrDefault());
            VIRP.CRS.BO.REFERRAL parentReferral = VIRP.CRS.BLL.REFERRALManager.GetItem(CurrentUser, CurrentRegistryId, parentCase.REFERRAL_ID.GetValueOrDefault());

            parentCase.UPDATEDBY = parentReferral.UPDATEDBY = CurrentUser;
            parentCase.UPDATED = parentReferral.UPDATED = DateTime.Now;

            if (parentReferral != null)
            {
                if (operation() == "Void")
                {
                    List<WKF_CASE> cases = ServiceInterfaceManager.WKF_CASE_GET_ALL_BY_REFERRAL(CurrentUser, CurrentRegistryId, parentReferral.REFERRAL_ID);
                    if (cases != null)
                    {
                        bool blnIncomplete = false;
                        foreach (WKF_CASE c in cases)
                        {
                            if (c.WKF_CASE_ID != parentCase.WKF_CASE_ID && c.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed)
                            {
                                blnIncomplete = true;
                                break;
                            }
                        }
                        if (!blnIncomplete)
                        {
                            if (parentReferral.STD_REFERRALSTS_ID != (int)VIRP.EFR.BO.ReferralStatus.Completed)
                            {
                                parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.Completed;
                                VIRP.CRS.BLL.REFERRALManager.Save(CurrentUser, CurrentRegistryId, parentReferral);
                            }
                        }
                    }

                    parentCase.STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed;
                    VIRP.CRS.BLL.WKF_CASEManager.Save(CurrentUser, CurrentRegistryId, parentCase);
                }
                else
                {
                    if (parentReferral.STD_REFERRALSTS_ID != (int)VIRP.EFR.BO.ReferralStatus.InProcess)
                    {
                        parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.InProcess;
                        VIRP.CRS.BLL.REFERRALManager.Save(CurrentUser, CurrentRegistryId, parentReferral);
                    }

                    if (parentCase.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess)
                    {
                        parentCase.STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess;
                        VIRP.CRS.BLL.WKF_CASEManager.Save(CurrentUser, CurrentRegistryId, parentCase);
                    }
                }

                //SuppressSaveSuccessMessage = true;
                //parentCase.WKF_CASE_ID = ServiceInterfaceManager.WKF_CASE_SAVE(CurrentUser, CurrentRegistryId, parentCase);
                //parentReferral.REFERRAL_ID = ServiceInterfaceManager.REFERRAL_SAVE(CurrentUser, CurrentRegistryId, parentReferral);

                //SuppressSaveSuccessMessage = false;
            }
        }

        //private void OpenCloseReferralAndWorkflowCase(WKF_CASE parentCase, Func<string> operation)
        //{
        //    ReferralManager rm = new ReferralManager();

        //    EFR_REFERRAL parentReferral = rm.getReferralByReferralID(parentCase.REFERRAL_ID.Value);

        //    parentReferral = SerializerUtil.Deserialize<EFR_REFERRAL>(parentReferral.Serialize());
        //    parentReferral.SetAsChangeTrackingRoot();

        //    if (operation() == "Void")
        //    {
        //        var items = parentReferral.WKF_CASEs.Except(new List<WKF_CASE> { parentCase }, new WorkflowCaseManager.WorkflowCaseComparer());

        //        if (items.Count(a => a.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.Completed) == 0)

        //            parentReferral.STD_REFERRALSTS_ID = (int)ReferralStatus.Completed;

        //        parentReferral.WKF_CASEs.Where(c => c.WKF_CASE_ID == parentCase.WKF_CASE_ID).First().STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.Completed;
        //    }
        //    else
        //    {
        //        if (parentReferral.STD_REFERRALSTS_ID != (int)ReferralStatus.InProcess)
        //            parentReferral.STD_REFERRALSTS_ID = (int)ReferralStatus.InProcess;

        //        if (parentCase.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.InProcess)
        //            parentReferral.WKF_CASEs.Where(c => c.WKF_CASE_ID == parentCase.WKF_CASE_ID).First().STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.InProcess;
        //    }

        //    SuppressSaveSuccessMessage = true;
        //    rm.Update(parentReferral);

        //    SuppressSaveSuccessMessage = false;
        //}

        private void UpdateCreateDataListAnalyte(DataListItem item, int detailId, bool insertFlag)
        {
            //UnitTestReferenceRangeManager unitRangeManager = new UnitTestReferenceRangeManager();

            if (Activity != null)
            {
                ANALYSIS_DETAIL detail = ANALYSIS_DETAILManager.GetItem(CurrentUser, CurrentRegistryId, detailId);
                if (detail == null)
                {
                    detail = new ANALYSIS_DETAIL();

                    detail.CREATED = DateTime.Now;
                    detail.UPDATED = DateTime.Now;
                    detail.CREATEDBY = CurrentUser;
                    detail.UPDATEDBY = CurrentUser;
                }

                //if (insertFlag)
                //{
                //    //create detail
                //    detail = new ANALYSIS_DETAIL();
                //    detail.SetAsChangeTrackingRoot(EntityState.New, true);
                //}
                //else
                //{
                //    //we found detail so just update it 
                //    detail = Activity.SPECIMEN_ANALYSIs.First().ANALYSIS_DETAILs.Where(t => t.ANALYSIS_DETAIL_ID == detailId).SingleOrDefault();

                //    detail.SetAsChangeTrackingRoot(true);
                //}

                DropDownList testNamesList = item.FindControl("TestNameList") as DropDownList;
                if (testNamesList != null)
                {
                    if (int.Parse(testNamesList.SelectedValue) == 0)
                    {
                        detail.STD_TEST_NAME_ID = null;
                    }
                    else
                    {
                        detail.STD_TEST_NAME_ID = int.Parse(testNamesList.SelectedValue);
                        detail.TEST_NAME = testNamesList.SelectedItem.Text;
                    }
                }

                DropDownList analyteNamesList = item.FindControl("AnalyteNameList") as DropDownList;
                if (analyteNamesList != null)
                {
                    if (int.Parse(analyteNamesList.SelectedValue) == 0)
                    {
                        detail.STD_ANALYTETYPE_ID = null;
                    }
                    else
                    {
                        detail.STD_ANALYTETYPE_ID = int.Parse(analyteNamesList.SelectedValue);

                        if (int.Parse(analyteNamesList.SelectedValue) == 15)
                        {
                            TextBox otherAnalyteBox = item.FindControl("OtherAnalyteBox") as TextBox;
                            if (otherAnalyteBox != null)
                            {
                                detail.ANALYTE_NAME = otherAnalyteBox.Text;
                            }
                        }
                        else
                        {
                            detail.ANALYTE_NAME = analyteNamesList.SelectedItem.Text;
                        }
                    }
                }

                DropDownList analyteMethodList = item.FindControl("AnalysisMethodList") as DropDownList;
                if (analyteMethodList != null)
                {
                    if (int.Parse(analyteMethodList.SelectedValue) == 0)
                    {
                        detail.STD_ANALYSISMETHOD_ID = null;
                        detail.ANALYSIS_METHOD_NAME = null;
                    }
                    else
                    {
                        if (detail.STD_ANALYSISMETHOD_ID.GetValueOrDefault() != int.Parse(analyteMethodList.SelectedValue))
                        {
                            detail.STD_ANALYSISMETHOD_ID = int.Parse(analyteMethodList.SelectedValue);

                            if (int.Parse(analyteMethodList.SelectedValue) == 7)
                            {
                                TextBox otherMethodBox = item.FindControl("OtherAnalysisMethodBox") as TextBox;
                                if (otherMethodBox != null)
                                {
                                    detail.ANALYSIS_METHOD_NAME = otherMethodBox.Text;
                                }
                            }
                            else
                            {
                                detail.ANALYSIS_METHOD_NAME = analyteMethodList.SelectedItem.Text;
                            }
                        }
                    }
                }

                //analysis result 
                TextBox analysisResultBox = item.FindControl("AnalysisResultBox") as TextBox;
                if (analysisResultBox != null)
                {
                    detail.RESULT_TEXT = analysisResultBox.Text;
                }

                STD_ANALYTE_TEST_REFERENCE_RANGE range = new STD_ANALYTE_TEST_REFERENCE_RANGE();

                if (testNamesList != null && analyteNamesList != null)
                {
                    range = GetTestReferenceRange(int.Parse(testNamesList.SelectedValue), int.Parse(analyteNamesList.SelectedValue));
                }

                DropDownList resultUnitList = item.FindControl("UnitList") as DropDownList;
                if (resultUnitList != null)
                {
                    if (int.Parse(resultUnitList.SelectedValue) == 0)
                    {
                        detail.RESULT_UNIT_ID = null;
                    }
                    else
                    {
                        detail.RESULT_UNIT_ID = int.Parse(resultUnitList.SelectedValue);
                    }
                }

                TextBox rangeBox = item.FindControl("ReferenceRangeBox") as TextBox;
                if (rangeBox != null)
                {
                    detail.LAB_REFERENCE_RANGE = rangeBox.Text;
                }

                DropDownList rangeUnitList = item.FindControl("ReferenceRangeUnitList") as DropDownList;
                if (rangeUnitList != null && rangeBox != null)
                {
                    if (int.Parse(rangeUnitList.SelectedValue) == 0 || String.IsNullOrEmpty(rangeBox.Text))
                    {
                        detail.LAB_REFERENCE_RANGE_UNIT_ID = null;
                    }
                    else
                    {
                        detail.LAB_REFERENCE_RANGE_UNIT_ID = int.Parse(rangeUnitList.SelectedValue);
                    }
                }

                if (range != null)
                {
                    detail.TEFSC_REFERENCE_RANGE = range.REFERENCE_RANGE;
                    detail.TEFSC_REFERENCE_RANGE_UNIT_ID = range.STD_UNITS_ID;
                }
                CheckBox aboveCheck = item.FindControl("AboveReferenceCheck") as CheckBox;

                if (aboveCheck != null)
                {
                    string isChecked = aboveCheck.Checked ? "1" : "0";
                    detail.LAB_ABOVE_REFERENCE_RANGE = Helpers.ToNullable<int>(isChecked);
                }

                TextBox evalNoteBox = item.FindControl("EvaluationNoteBox") as TextBox;
                if (evalNoteBox != null)
                {
                    detail.EVAL_COMMENT_TEXT = evalNoteBox.Text;
                }

                TextBox commentBox = item.FindControl("CommentBox") as TextBox;
                if (commentBox != null)
                {
                    detail.OTHER_COMMENT_TEXT = commentBox.Text;
                }

                if (insertFlag)
                {
                    SPECIMEN_ANALYSIS analysis = null;

                    List<SPECIMEN_ANALYSIS> analysisList = SPECIMEN_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, Activity.WKF_CASE_ACTIVITY_ID);
                    if (analysisList != null && analysisList.Count > 0)
                    {
                        analysis = analysisList.First();
                    }
                    else
                    {
                        analysis = new SPECIMEN_ANALYSIS();
                        analysis.CREATED = analysis.UPDATED = DateTime.Now;
                        analysis.CREATEDBY = analysis.UPDATEDBY = CurrentUser;
                        analysis.WKF_CASE_ACTIVITY_ID = Activity.WKF_CASE_ACTIVITY_ID;
                        analysis.LAB_ORDER_ID = GetLabOrderId(Activity.WKF_CASE_ACTIVITY_ID);
                        analysis.SPECIMEN_ANALYSIS_ID = SPECIMEN_ANALYSISManager.Save(CurrentUser, CurrentRegistryId, analysis);
                    }

                    detail.SPECIMEN_ANALYSIS_ID = analysis.SPECIMEN_ANALYSIS_ID;
                    detail.ANALYSIS_DETAIL_ID = ANALYSIS_DETAILManager.Save(CurrentUser, CurrentRegistryId, detail);

                    //if (WkfCase.WKF_CASE_ACTIVITies[0].SPECIMEN_ANALYSIs.Count() > 0)
                    //{
                    //    WkfCase.WKF_CASE_ACTIVITies[0].SPECIMEN_ANALYSIs[0].ANALYSIS_DETAILs.Add(detail);
                    //    detail.SetAsInsertOnSubmit();
                    //}
                    //else
                    //{
                    //    SPECIMEN_ANALYSI analysis = new SPECIMEN_ANALYSI();
                    //    analysis.SetAsChangeTrackingRoot();
                    //    analysis.WKF_CASE_ACTIVITY_ID = Activity.WKF_CASE_ACTIVITY_ID;
                    //    analysis.LAB_ORDER_ID = labResultsManager.GetLabOrderId(WkfCase.WKF_CASE_ACTIVITies[0].WKF_CASE_ACTIVITY_ID);

                    //    analysis.SetAsInsertOnSubmit(true);

                    //    analysis.ANALYSIS_DETAILs.Add(detail);
                    //    WkfCase.WKF_CASE_ACTIVITies[0].SPECIMEN_ANALYSIs.Add(analysis);
                    //}
                }

                WkfCase.WKF_CASE_ID = VIRP.CRS.BLL.WKF_CASEManager.Save(CurrentUser, CurrentRegistryId, WkfCase);
                //labResultsManager.UpdateResultActivity(WkfCase);
                GetRefreshLabResults(Activity.WKF_CASE_ACTIVITY_ID);
            }
        }

        private WKF_CASE_ACTIVITY GetLabOrderByCaseId(int caseId)
        {
            WKF_CASE_ACTIVITY activity = null;

            List<WKF_CASE_ACTIVITY> activityList = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(CurrentUser, CurrentRegistryId, caseId);
            if (activityList != null)
            {
                activity = activityList.Where(acts => acts.STD_WKFACTIVITYTYPE_ID == (int)WorkFlowActivityTypes.LabOrder && acts.ARCHIVED_FLAG == false).FirstOrDefault();
            }
            //using (_db = GetDataContext())
            //{
            //    activity = (from acts in _db.WKF_CASE_ACTIVITies
            //                where acts.WKF_CASE_ID == caseId
            //                && acts.STD_WKFACTIVITYTYPE_ID == (int)WorkFlowActivityTypes.LabOrder
            //                && acts.ARCHIVED_FLAG == false
            //                select acts).FirstOrDefault();
            //    activity.SetAsChangeTrackingRoot();
            //}

            return activity;
        }

        private WKF_CASE_ACTIVITY SelectByActivityType(int caseId, string activityType)
        {
            WKF_CASE_ACTIVITY activity = null;

            List<WKF_CASE_ACTIVITY> activityList = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(CurrentUser, CurrentRegistryId, caseId);
            if (activityList != null)
            {
                WorkFlowActivityTypes type = (WorkFlowActivityTypes)Enum.Parse(typeof(WorkFlowActivityTypes), activityType);
                activity = activityList.Where(acts => acts.STD_WKFACTIVITYTYPE_ID == (int)type).FirstOrDefault();
            }

            //_db = GetDataContext();
            //SetLoadActivityTypeWith(_db);

            //WorkFlowActivityTypes type = (WorkFlowActivityTypes)Enum.Parse(typeof(WorkFlowActivityTypes), activityType);

            //objReturn = SelectByCaseLinqFilter(caseId).Where(e => e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(type)).FirstOrDefault();
            //_db.Dispose();

            return activity;
        }

        private STD_ANALYTE_TEST_REFERENCE_RANGE GetTestReferenceRange(int testId, int analyteId)
        {
            STD_ANALYTE_TEST_REFERENCE_RANGE entity = null;

            List<STD_ANALYTE_TEST_REFERENCE_RANGE> entityList = STD_ANALYTE_TEST_REFERENCE_RANGEManager.GetItems(CurrentUser, CurrentRegistryId);
            if (entityList != null)
                entity = entityList.Where(trr => trr.STD_TEST_NAME_ID == testId && trr.STD_ANALYTE_TYPE_ID == analyteId).FirstOrDefault();

            //_db = GetDataContext();
            //SetLoadWith(_db);
            //entity = (from trr in _db.STD_ANALYTE_TEST_REFERENCE_RANGEs where trr.STD_TEST_NAME_ID == testId && trr.STD_ANALYTE_TYPE_ID == analyteId select trr).FirstOrDefault();
            //_db.Dispose();

            return entity;
        }

        private WKF_CASE_ACTIVITY CreateNewInterpretationActivity(int caseId)
        {
            WKF_CASE_ACTIVITY Activity = new WKF_CASE_ACTIVITY();
            Activity.WKF_CASE_ID = caseId;
            Activity.CREATED = Activity.UPDATED = DateTime.Now;
            Activity.CREATEDBY = Activity.UPDATEDBY = CurrentUser;
            Activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.New);
            Activity.STD_WKFACTIVITYTYPE_ID = Convert.ToInt16(WorkFlowActivityTypes.Interpretation);
            Activity.REPRESENTATIVE_NAME = string.Empty;
            return Activity;
        }

        private int GetLabOrderId(int ActivityId)
        {
            int objReturn = 0;

            List<LAB_ORDER> orders = LAB_ORDERManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, ActivityId);
            if (orders != null && orders.Count > 0)
            {
                LAB_ORDER order = orders.First();
                objReturn = order.LAB_ORDER_ID;
            }

            return objReturn;

            //using (_db = GetDataContext())
            //{
            //    var order = //(from lo in _db.LAB_ORDERs
            //                 (from wc in _db.WKF_CASEs
            //                  where wc.WKF_CASE_ACTIVITies.Any(c => c.WKF_CASE_ACTIVITY_ID == ActivityId)
            //                  let c = wc.WKF_CASE_ACTIVITies.Where(c => c.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.LabOrder)).SingleOrDefault()
            //                  select c.LAB_ORDERs.FirstOrDefault().LAB_ORDER_ID).FirstOrDefault();
            //    return (int)order;
            //}
        }

        private void UnacceptLabResults(int activityStatusId, int workCaseId, Button button)
        {
            //if (currentUser.GetRoles().Contains((int)RoleCode.EFR_TEFSC_COORDINATOR))
            //{
            button.Enabled = true;
            if (activityStatusId == (int)WorkflowCaseActivityStatus.Accepted)
            {
                button.Text = "Unaccept";

                VIRP.CRS.BO.WKF_CASE_ACTIVITY activity = GetInterpretationLetterWorkcaseActivity(workCaseId, (int)VIRP.EFR.BO.WorkFlowCaseActivityType.InterpretationDiagnosis);

                string message1 = "Are you sure that you want to Unaccept this lab result?";
                string message2 = string.Empty;
                string message3 = string.Empty;
                string message4 = string.Empty;
                string message5 = string.Empty;
                string message6 = string.Empty;
                if (activity != null)
                {
                    if (activity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.InProcess)
                    {
                        message2 = "Intepretation letters have been started but not completed.";
                        message3 = "These letters will be deleted.";
                    }
                    else if (activity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.Interpreted)
                    {
                        message2 = "Interpretation letters have been completed.";
                        message3 = "The contact log has been updated.";
                        message4 = "These letters will be saved as part of the change history for this lab result.";
                        message5 = "A new contact log entry will be created.";
                    }
                }
                button.OnClientClick = "return DisplayWarningMessage('"
                    + message1 + "', '" + message2 + "', '" + message3 + "', '"
                    + message4 + "', '" + message5 + "', '" + message6 + "');";
            }
            else
            {
                button.Text = "Accept";
                button.OnClientClick = "return confirm('Please note that after pressing the Accept button this record will become static (non-editable). Are you sure that you want to accept this lab result?');";
            }
            //}
        }

        /// <summary>
        /// Unaccept a lab results
        /// </summary>
        /// <param name="labResultsActivity"></param>
        private void UnacceptLabResults(VIRP.CRS.BO.WKF_CASE_ACTIVITY labResultsActivity, VIRP.CRS.BO.WKF_CASE workCase)
        {
            //WorkflowCaseManager wfcManager = new WorkflowCaseManager();
            //LabResultsManager labManager = new LabResultsManager();
            bool changeToInprocess = true;

            VIRP.CRS.BO.WKF_CASE_ACTIVITY letterActivity =
                GetInterpretationLetterWorkcaseActivity(labResultsActivity.WKF_CASE_ID,
                (int)VIRP.EFR.BO.WorkFlowCaseActivityType.InterpretationDiagnosis);

            if (letterActivity != null)
            {
                // The letter is in process 
                // Delete the letter record and update the activity record to New as status
                if (letterActivity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.InProcess)
                {
                    //Delete the interpretation letter record 
                    //DeleteInterpreationLetter(letterActivity.WKF_CASE_ACTIVITY_ID);
                    INTERPRETATION_LETTERManager.DeleteByActivity(CurrentUser, CurrentRegistryId, letterActivity.WKF_CASE_ACTIVITY_ID);

                    //Delete interpretation letter activity record
                    VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.Delete(CurrentUser, CurrentRegistryId, letterActivity.WKF_CASE_ACTIVITY_ID);
                    //ServiceInterfaceManager.WKF_CASE_ACTIVITY_DELETE(CurrentUser, CurrentRegistryId, letterActivity.WKF_CASE_ACTIVITY_ID);
                    //wfcManager.DeleteWorkCaseActivity(letterActivity.WKF_CASE_ACTIVITY_ID);
                }
                // The letter is completed
                else if (letterActivity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.Interpreted)
                {
                    changeToInprocess = false;

                    // Create a new contact log
                    ContactLog lastPrintedContact = Helpers.GetLastPrintedContactLog(CurrentUser, CurrentRegistryId, workCase.REFERRAL_ID.GetValueOrDefault());

                    if (lastPrintedContact != null)
                    {
                        string contactMessage = "Lab results were unaccepted for an Interpretation Letter that was printed by "
                            + lastPrintedContact.ContactInitiator + " on "
                            + lastPrintedContact.ContactDate + ".";

                        CreateNewContactLog((int)workCase.PATIENT_ID, (int)workCase.REFERRAL_ID, EFRSharedConstant.ContactLogReasonUnaccepted, contactMessage, EFRSharedConstant.ContactLogMethodSystem);
                    }

                    // Create a new copy of the current lab results activity 
                    CreateNewCopyOfCurrentLabResults(labResultsActivity.WKF_CASE_ACTIVITY_ID);

                    // Archive the current lab results activity 
                    //UpdateActivityStatus(labResultsActivity.WKF_CASE_ACTIVITY_ID, (int)WorkflowCaseActivityStatus.Accepted, true);
                    labResultsActivity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.Accepted;
                    labResultsActivity.ARCHIVED_FLAG = true;
                    labResultsActivity.UPDATEDBY = CurrentUser;
                    labResultsActivity.UPDATED = DateTime.Now;
                    VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, labResultsActivity);

                    //Archive the interpreted letter 
                    //UpdateActivityStatus(letterActivity.WKF_CASE_ACTIVITY_ID, (int)WorkflowCaseActivityStatus.Interpreted, true);
                    letterActivity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.Interpreted;
                    letterActivity.ARCHIVED_FLAG = true;
                    letterActivity.UPDATEDBY = CurrentUser;
                    letterActivity.UPDATED = DateTime.Now;
                    VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, letterActivity);

                    // Create change history records
                    CreateChangeHistoryRecordsWhenUnaccept(labResultsActivity.WKF_CASE_ID, labResultsActivity.WKF_CASE_ACTIVITY_ID, letterActivity.WKF_CASE_ACTIVITY_ID);
                }
            }

            if (changeToInprocess)
            {
                //Change the activity status to In Process
                //UpdateActivityStatus(labResultsActivity.WKF_CASE_ACTIVITY_ID, (int)WorkflowCaseActivityStatus.InProcess, false);
                labResultsActivity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.InProcess;
                labResultsActivity.ARCHIVED_FLAG = false;
                VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, labResultsActivity);
            }
        }

        /// <summary>
        /// Get the work flow case activity record for interpretation letter
        /// </summary>
        /// <param name="workcaseId"></param>
        /// <param name="activityTypeId"></param>
        /// <returns></returns>
        private VIRP.CRS.BO.WKF_CASE_ACTIVITY GetInterpretationLetterWorkcaseActivity(int workcaseId, int activityTypeId)
        {
            VIRP.CRS.BO.WKF_CASE_ACTIVITY activity = null;
            List<VIRP.CRS.BO.WKF_CASE_ACTIVITY> activityList = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.GetitemsByWorkflowCaseId(CurrentUser, CurrentRegistryId, workcaseId);

            if (activityList != null)
            {
                foreach (VIRP.CRS.BO.WKF_CASE_ACTIVITY act in activityList)
                {
                    if (act.STD_WKFACTIVITYTYPE_ID == activityTypeId)
                    {
                        activity = act;
                        break;
                    }
                }
            }

            //List<WKF_CASE_ACTIVITY> activityList = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(CurrentUser, CurrentRegistryId, workcaseId);
            //if (activityList != null)
            //{
            //    activity = activityList.Where(acts => acts.STD_WKFACTIVITYTYPE_ID == activityTypeId).FirstOrDefault();
            //}

            return activity;
            //WorkflowCaseManager wfcManager = new WorkflowCaseManager();
            //return wfcManager.SelectByCaseIdAndActivityTypeId(workcaseId, activityTypeId);
        }

        /// <summary>
        /// Create three new change history records when unaccepting a lab result
        /// </summary>
        /// <param name="workCaseId"></param>
        /// <param name="labActivityId"></param>
        /// <param name="interpreationActivityId"></param>
        private void CreateChangeHistoryRecordsWhenUnaccept(int workCaseId, int labActivityId, int interpreationActivityId)
        {
            LABRESULT_CHANGE_TRACKING changeHistory = null;
            string url = string.Empty;

            // Provider letter archived
            url = string.Format("../LabResultsInterpretationLetters.aspx?activityId={0}&intActivityId={1}&RptType={2}&CaseId={3}", labActivityId, interpreationActivityId, "1", workCaseId);
            changeHistory = CreateNewChangeHistoryObject(workCaseId, EFRSharedConstant.LabResultsChangeHistoryProviderLetterArchived, url);
            //CreatOneChangeHistoryRecord(changeHistory);
            LABRESULT_CHANGE_TRACKINGManager.Save(CurrentUser, CurrentRegistryId, changeHistory);

            // Patient letter archived
            url = string.Format("../LabResultsInterpretationLetters.aspx?activityId={0}&intActivityId={1}&RptType={2}&CaseId={3}", labActivityId, interpreationActivityId, "0", workCaseId);
            changeHistory = CreateNewChangeHistoryObject(workCaseId, EFRSharedConstant.LabResultsChangeHistoryPatientLetterArchived, url);
            //CreatOneChangeHistoryRecord(changeHistory);
            LABRESULT_CHANGE_TRACKINGManager.Save(CurrentUser, CurrentRegistryId, changeHistory);

            // Unaccept contact log created
            changeHistory = CreateNewChangeHistoryObject(workCaseId, EFRSharedConstant.LabResultsChangeHistoryContactLogCreated, string.Empty);
            //CreatOneChangeHistoryRecord(changeHistory);
            LABRESULT_CHANGE_TRACKINGManager.Save(CurrentUser, CurrentRegistryId, changeHistory);
        }

        /// <summary>
        /// Create a new change history object
        /// </summary>
        /// <param name="workCaseId"></param>
        /// <param name="descriptionText"></param>
        /// <param name="navigationUrl"></param>
        /// <returns></returns>
        private static LABRESULT_CHANGE_TRACKING CreateNewChangeHistoryObject(int workCaseId, string descriptionText, string navigationUrl)
        {
            LABRESULT_CHANGE_TRACKING changeHistory = new LABRESULT_CHANGE_TRACKING();

            changeHistory.WKF_CASE_ID = workCaseId;
            changeHistory.CHANGE_DATE = DateTime.Now;
            changeHistory.CHANGE_DESCRIPTION = descriptionText;
            if (!string.IsNullOrEmpty(navigationUrl))
            {
                changeHistory.NAVIGATION_URL = navigationUrl;
            }

            return changeHistory;
        }

        /// <summary>
        /// Insert a new record to LABRESULT_CHANGE_TRACKING table
        /// </summary>
        /// <param name="changeTracking"></param>
        /// 
        //private void CreatOneChangeHistoryRecord(LABRESULT_CHANGE_TRACKING changeTracking)
        //{
        //    changeTracking.LABRESULT_CHANGE_TRACKING_ID = LABRESULT_CHANGE_TRACKINGManager.Save(CurrentUser, CurrentRegistryId, changeTracking);
        //    //LabResultsTrackingManager manager = new LabResultsTrackingManager();
        //    //changeTracking.SetAsChangeTrackingRoot();
        //    //changeTracking.SetAsInsertOnSubmit();
        //    //manager.Update(changeTracking);
        //}

        /// <summary>
        /// Update work flow case activity record with status and archived flag
        /// </summary>
        /// <param name="activityId"></param>
        /// <param name="statusId"></param>
        /// <param name="archived"></param>
        /// <returns></returns>
        //private void UpdateActivityStatus(int activityId, int statusId, bool archived)
        //{
        //    WKF_CASE_ACTIVITY activity = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET(CurrentUser, CurrentRegistryId, activityId);
        //    activity.STD_WKFACTIVITYSTS_ID = statusId;
        //    activity.ARCHIVED_FLAG = archived;
        //    activity.WKF_CASE_ACTIVITY_ID = ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(CurrentUser, CurrentRegistryId, activity);
        //}

        /// <summary>
        /// Create a new copy of lab results and insert to the database
        /// This is for archive the current copy of the lab results.
        /// </summary>
        /// <param name="activityId"></param>
        /// <returns></returns>
        private void CreateNewCopyOfCurrentLabResults(int activityId)
        {
            //WKF_CASE_ACTIVITY activity = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET(CurrentUser, CurrentRegistryId, activityId);
            VIRP.CRS.BO.WKF_CASE_ACTIVITY activity = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.GetItem(CurrentUser, CurrentRegistryId, activityId);
 
            activity.WKF_CASE_ACTIVITY_ID = 0;
            activity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.InProcess;
            activity.WKF_CASE_ACTIVITY_ID = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, activity);
            //ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(CurrentUser, CurrentRegistryId, activity);

            //List <LAB_ORDER> orders = LAB_ORDERManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, activityId);
            //if (orders != null)
            //{
            //    foreach (LAB_ORDER order in orders)
            //    {
            //        order.LAB_ORDER_ID = 0;
            //        order.WKF_CASE_ACTIVITY_ID = activity.WKF_CASE_ACTIVITY_ID;
            //        order.LAB_ORDER_ID = LAB_ORDERManager.Save(CurrentUser, CurrentRegistryId, order);
            //    }
            //}

            List<SPECIMEN_ANALYSIS> analysisList = SPECIMEN_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, activityId);

            if (analysisList != null)
            {
                foreach (SPECIMEN_ANALYSIS analysis in analysisList)
                {
                    int tempAnalysisId = analysis.SPECIMEN_ANALYSIS_ID;
                    analysis.SPECIMEN_ANALYSIS_ID = 0;
                    analysis.UPDATEDBY = CurrentUser;
                    analysis.WKF_CASE_ACTIVITY_ID = activity.WKF_CASE_ACTIVITY_ID;
                    analysis.SPECIMEN_ANALYSIS_ID = SPECIMEN_ANALYSISManager.Save(CurrentUser, CurrentRegistryId, analysis);

                    List<ANALYSIS_DETAIL> detailList = ANALYSIS_DETAILManager.GetItemsBySpecimen(CurrentUser, CurrentRegistryId, tempAnalysisId);

                    if (detailList != null)
                    {
                        foreach (ANALYSIS_DETAIL detail in detailList)
                        {
                            detail.ANALYSIS_DETAIL_ID = 0;
                            analysis.UPDATEDBY = CurrentUser;
                            detail.SPECIMEN_ANALYSIS_ID = analysis.SPECIMEN_ANALYSIS_ID;
                            detail.ANALYSIS_DETAIL_ID = ANALYSIS_DETAILManager.Save(CurrentUser, CurrentRegistryId, detail);
                        }
                    }
                }
            }

            List<FRAGMENT_ANALYSIS> fragmentList = FRAGMENT_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, activityId);

            if (fragmentList != null)
            {
                foreach (FRAGMENT_ANALYSIS fragment in fragmentList)
                {
                    int tempFragmentId = fragment.FRAGMENT_ANALYSIS_ID;
                    fragment.FRAGMENT_ANALYSIS_ID = 0;
                    fragment.UPDATEDBY = CurrentUser;
                    fragment.WKF_CASE_ACTIVITY_ID = activity.WKF_CASE_ACTIVITY_ID;
                    fragment.FRAGMENT_ANALYSIS_ID = FRAGMENT_ANALYSISManager.Save(CurrentUser, CurrentRegistryId, fragment);

                    List<ANALYSIS_DETAIL> detailList = ANALYSIS_DETAILManager.GetItemsByFragmentExact(CurrentUser, CurrentRegistryId, tempFragmentId);
                    if (detailList != null)
                    {
                        foreach (ANALYSIS_DETAIL detail in detailList)
                        {
                            detail.ANALYSIS_DETAIL_ID = 0;
                            detail.UPDATEDBY = CurrentUser;
                            detail.FRAGMENT_ANALYSIS_ID = fragment.FRAGMENT_ANALYSIS_ID;
                            detail.ANALYSIS_DETAIL_ID = ANALYSIS_DETAILManager.Save(CurrentUser, CurrentRegistryId, detail);
                        }
                    }
                }
            }            

            //WKF_CASE_ACTIVITY labResults = null;
            //using (_db = GetDataContext())
            //{
            //    SetLoadwithForLabResultsCreateNewCopy(_db);
            //    labResults = (from c in _db.WKF_CASE_ACTIVITies
            //                  where c.WKF_CASE_ACTIVITY_ID == activityId
            //                  select c).FirstOrDefault();
            //    labResults.SetAsChangeTrackingRoot();
            //}

            //WKF_CASE_ACTIVITY newLab = labResults.Clone();
            //newLab.SetAsChangeTrackingRoot();
            //newLab.SetAsInsertOnSubmit();
            //newLab.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.InProcess;

            //foreach (SPECIMEN_ANALYSI specimen in newLab.SPECIMEN_ANALYSIs)
            //{
            //    foreach (ANALYSIS_DETAIL detail in specimen.ANALYSIS_DETAILs)
            //    {
            //        detail.SetAsInsertOnSubmit();
            //    }
            //    specimen.SetAsInsertOnSubmit();
            //}

            //foreach (FRAGMENT_ANALYSI fragment in newLab.FRAGMENT_ANALYSIs)
            //{
            //    foreach (ANALYSIS_DETAIL detail in fragment.ANALYSIS_DETAILs)
            //    {
            //        detail.SetAsInsertOnSubmit();
            //    }
            //    fragment.SetAsInsertOnSubmit();
            //}

            //using (_db = GetDataContext())
            //{
            //    _db.DeferredLoadingEnabled = false;
            //    newLab.SynchroniseWithDataContext(_db, true);

            //    try
            //    {
            //        _db.SubmitChanges(ConflictMode.ContinueOnConflict);
            //        returnStatus = 0;

            //    }
            //    catch (ChangeConflictException)
            //    {
            //        _db.ChangeConflicts.ResolveAll(RefreshMode.KeepChanges);
            //        returnStatus = 0;
            //    }
            //    catch
            //    {
            //        returnStatus = -1;
            //    }
            //}
        }

        private void CreateNewContactLog(int patientId, int referralId, string reason, string contactMessage, string contactMethod)
        {
            //Get Patient
            //PatientManager patientManager = new PatientManager();
            ////PATIENT patient = patientManager.SelectByPatientID(patientId);
            //PATIENT patient = ServiceInterfaceManager.PATIENT_GET(CurrentUser, CurrentRegistryId, patientId);
            //PATIENT_REG patientReg = ServiceInterfaceManager.PATIENT_REG_GET(CurrentUser, CurrentRegistryId, patientId);
            VIRP.CRS.BO.PATIENT patient = VIRP.CRS.BLL.PATIENTManager.GetItem(CurrentUser, CurrentRegistryId, patientId);
            VIRP.CRS.BO.PATIENT_REG patientReg = VIRP.CRS.BLL.PATIENT_REGManager.GetItem(CurrentUser, CurrentRegistryId, patientId);

            //Populate new contact log object
            CONTACT_LOG contact = new CONTACT_LOG();

            contact.REFERRAL_ID = referralId;
            contact.CONTACT_FIRST_NAME = patient.FIRST_NAME;
            contact.CONTACT_LAST_NAME = patient.LAST_NAME;
            contact.CONTACT_DATE = DateTime.Now;
            contact.CONTACT_METHOD_TEXT = contactMethod;
            contact.CONTACT_EMAIL = null;
            contact.CONTACT_ADDR1 = patientReg.ADDRESS_LINE1;
            contact.CONTACT_ADDR2 = patientReg.ADDRESS_LINE2;
            contact.CONTACT_ADDR3 = patientReg.ADDRESS_LINE3;
            contact.CONTACT_CITY = patientReg.CITY;
            contact.CONTACT_STATE = patientReg.STATE;
            contact.CONTACT_POSTAL = patientReg.POSTAL_CODE;
            contact.CONTACT_ZIPPLUS4 = patientReg.ZIP_PLUS_4;
            contact.CONTACT_COUNTRY = patientReg.COUNTRY;
            contact.CONTACT_REASON_TEXT = reason;
            contact.TELEMEDICINE_PATIENT_FLAG = false;
            contact.TELEMEDICINE_PROVIDER_FLAG = false;
            contact.INPATIENT_EVAL_RECOM_FLAG = false;
            contact.CONTACT_MESSAGE_TEXT = contactMessage;

            contact.CONTACT_LOG_ID = CONTACT_LOGManager.Save(CurrentUser, CurrentRegistryId, contact);

            //contact.SetAsChangeTrackingRoot();
            //contact.SetAsInsertOnSubmit();

            //ContactLogManager manager = new ContactLogManager();
            //manager.Update(contact);
        }

        protected override void Ds_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);

            try
            {
                //e.InputParameters.Clear();

                //string txtSearch = TextBoxSearchCriteria.Text;
                //string listFacility = DropDownListFacility.SelectedValue;

                if (e.InputParameters["CURRENT_USER"] != null)
                    e.InputParameters["CURRENT_USER"] = HttpContext.Current.User.Identity.Name;
                else
                    e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);

                if (e.InputParameters["CURRENT_REGISTRY_ID"] != null)
                    e.InputParameters["CURRENT_REGISTRY_ID"] = UserSession.CurrentRegistryId;
                else
                    e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);

                //e.InputParameters.Add("lastName", txtSearch);
                //e.InputParameters.Add("facilityId", listFacility);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);
                throw ex;
            }
        }
    }
}